/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceShareType {
    FOREIGN("FOREIGN"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceShareType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceShareType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceShareType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceShareType> knownValues() {
        return Stream.of(ResourceShareType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

