/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TaskType {
    EVALUATION("EVALUATION"),
    LABELING_SET_GENERATION("LABELING_SET_GENERATION"),
    IMPORT_LABELS("IMPORT_LABELS"),
    EXPORT_LABELS("EXPORT_LABELS"),
    FIND_MATCHES("FIND_MATCHES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TaskType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TaskType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskType> knownValues() {
        return Stream.of(TaskType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

