/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionFailureEntry;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionFailureListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdatePartitionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchUpdatePartitionResponse> {
    private static final SdkField<List<BatchUpdatePartitionFailureEntry>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchUpdatePartitionResponse.getter(BatchUpdatePartitionResponse::errors)).setter(BatchUpdatePartitionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdatePartitionFailureEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));
    private final List<BatchUpdatePartitionFailureEntry> errors;

    private BatchUpdatePartitionResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<BatchUpdatePartitionFailureEntry> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdatePartitionResponse)) {
            return false;
        }
        BatchUpdatePartitionResponse other = (BatchUpdatePartitionResponse)((Object)obj);
        return Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchUpdatePartitionResponse").add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdatePartitionResponse, T> g) {
        return obj -> g.apply((BatchUpdatePartitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<BatchUpdatePartitionFailureEntry> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdatePartitionResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final Collection<BatchUpdatePartitionFailureEntry.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(BatchUpdatePartitionFailureEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchUpdatePartitionFailureEntry> errors) {
            this.errors = BatchUpdatePartitionFailureListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchUpdatePartitionFailureEntry ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchUpdatePartitionFailureEntry.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchUpdatePartitionFailureEntry)((BatchUpdatePartitionFailureEntry.Builder)BatchUpdatePartitionFailureEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchUpdatePartitionFailureEntry.BuilderImpl> errors) {
            this.errors = BatchUpdatePartitionFailureListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchUpdatePartitionResponse build() {
            return new BatchUpdatePartitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdatePartitionResponse> {
        public Builder errors(Collection<BatchUpdatePartitionFailureEntry> var1);

        public Builder errors(BatchUpdatePartitionFailureEntry ... var1);

        public Builder errors(Consumer<BatchUpdatePartitionFailureEntry.Builder> ... var1);
    }
}

