/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Classifier;
import software.amazon.awssdk.services.glue.model.ClassifierListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClassifiersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetClassifiersResponse> {
    private static final SdkField<List<Classifier>> CLASSIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Classifiers").getter(GetClassifiersResponse.getter(GetClassifiersResponse::classifiers)).setter(GetClassifiersResponse.setter(Builder::classifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Classifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetClassifiersResponse.getter(GetClassifiersResponse::nextToken)).setter(GetClassifiersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Classifier> classifiers;
    private final String nextToken;

    private GetClassifiersResponse(BuilderImpl builder) {
        super(builder);
        this.classifiers = builder.classifiers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasClassifiers() {
        return this.classifiers != null && !(this.classifiers instanceof SdkAutoConstructList);
    }

    public List<Classifier> classifiers() {
        return this.classifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClassifiersResponse)) {
            return false;
        }
        GetClassifiersResponse other = (GetClassifiersResponse)((Object)obj);
        return Objects.equals(this.classifiers(), other.classifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetClassifiersResponse").add("Classifiers", this.classifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classifiers": {
                return Optional.ofNullable(clazz.cast(this.classifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClassifiersResponse, T> g) {
        return obj -> g.apply((GetClassifiersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Classifier> classifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClassifiersResponse model) {
            super(model);
            this.classifiers(model.classifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Classifier.Builder> getClassifiers() {
            return this.classifiers != null ? (Collection)this.classifiers.stream().map(Classifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classifiers(Collection<Classifier> classifiers) {
            this.classifiers = ClassifierListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(Classifier ... classifiers) {
            this.classifiers(Arrays.asList(classifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(Consumer<Classifier.Builder> ... classifiers) {
            this.classifiers(Stream.of(classifiers).map(c -> (Classifier)((Classifier.Builder)Classifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClassifiers(Collection<Classifier.BuilderImpl> classifiers) {
            this.classifiers = ClassifierListCopier.copyFromBuilder(classifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetClassifiersResponse build() {
            return new GetClassifiersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClassifiersResponse> {
        public Builder classifiers(Collection<Classifier> var1);

        public Builder classifiers(Classifier ... var1);

        public Builder classifiers(Consumer<Classifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

