/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.JobRun;
import software.amazon.awssdk.services.glue.model.JobRunListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobNodeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobNodeDetails> {
    private static final SdkField<List<JobRun>> JOB_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobRuns").getter(JobNodeDetails.getter(JobNodeDetails::jobRuns)).setter(JobNodeDetails.setter(Builder::jobRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<JobRun> jobRuns;

    private JobNodeDetails(BuilderImpl builder) {
        this.jobRuns = builder.jobRuns;
    }

    public boolean hasJobRuns() {
        return this.jobRuns != null && !(this.jobRuns instanceof SdkAutoConstructList);
    }

    public List<JobRun> jobRuns() {
        return this.jobRuns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRuns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobNodeDetails)) {
            return false;
        }
        JobNodeDetails other = (JobNodeDetails)obj;
        return Objects.equals(this.jobRuns(), other.jobRuns());
    }

    public String toString() {
        return ToString.builder((String)"JobNodeDetails").add("JobRuns", this.jobRuns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobRuns": {
                return Optional.ofNullable(clazz.cast(this.jobRuns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobNodeDetails, T> g) {
        return obj -> g.apply((JobNodeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<JobRun> jobRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobNodeDetails model) {
            this.jobRuns(model.jobRuns);
        }

        public final Collection<JobRun.Builder> getJobRuns() {
            return this.jobRuns != null ? (Collection)this.jobRuns.stream().map(JobRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunListCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun ... jobRuns) {
            this.jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(Consumer<JobRun.Builder> ... jobRuns) {
            this.jobRuns(Stream.of(jobRuns).map(c -> (JobRun)((JobRun.Builder)JobRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunListCopier.copyFromBuilder(jobRuns);
        }

        public JobNodeDetails build() {
            return new JobNodeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobNodeDetails> {
        public Builder jobRuns(Collection<JobRun> var1);

        public Builder jobRuns(JobRun ... var1);

        public Builder jobRuns(Consumer<JobRun.Builder> ... var1);
    }
}

