/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CodeGenEdge;
import software.amazon.awssdk.services.glue.model.CodeGenNode;
import software.amazon.awssdk.services.glue.model.DagEdgesCopier;
import software.amazon.awssdk.services.glue.model.DagNodesCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataflowGraphResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataflowGraphResponse> {
    private static final SdkField<List<CodeGenNode>> DAG_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DagNodes").getter(GetDataflowGraphResponse.getter(GetDataflowGraphResponse::dagNodes)).setter(GetDataflowGraphResponse.setter(Builder::dagNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CodeGenEdge>> DAG_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DagEdges").getter(GetDataflowGraphResponse.getter(GetDataflowGraphResponse::dagEdges)).setter(GetDataflowGraphResponse.setter(Builder::dagEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagEdges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenEdge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_NODES_FIELD, DAG_EDGES_FIELD));
    private final List<CodeGenNode> dagNodes;
    private final List<CodeGenEdge> dagEdges;

    private GetDataflowGraphResponse(BuilderImpl builder) {
        super(builder);
        this.dagNodes = builder.dagNodes;
        this.dagEdges = builder.dagEdges;
    }

    public boolean hasDagNodes() {
        return this.dagNodes != null && !(this.dagNodes instanceof SdkAutoConstructList);
    }

    public List<CodeGenNode> dagNodes() {
        return this.dagNodes;
    }

    public boolean hasDagEdges() {
        return this.dagEdges != null && !(this.dagEdges instanceof SdkAutoConstructList);
    }

    public List<CodeGenEdge> dagEdges() {
        return this.dagEdges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dagNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dagEdges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowGraphResponse)) {
            return false;
        }
        GetDataflowGraphResponse other = (GetDataflowGraphResponse)((Object)obj);
        return Objects.equals(this.dagNodes(), other.dagNodes()) && Objects.equals(this.dagEdges(), other.dagEdges());
    }

    public String toString() {
        return ToString.builder((String)"GetDataflowGraphResponse").add("DagNodes", this.dagNodes()).add("DagEdges", this.dagEdges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DagNodes": {
                return Optional.ofNullable(clazz.cast(this.dagNodes()));
            }
            case "DagEdges": {
                return Optional.ofNullable(clazz.cast(this.dagEdges()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowGraphResponse, T> g) {
        return obj -> g.apply((GetDataflowGraphResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<CodeGenNode> dagNodes = DefaultSdkAutoConstructList.getInstance();
        private List<CodeGenEdge> dagEdges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowGraphResponse model) {
            super(model);
            this.dagNodes(model.dagNodes);
            this.dagEdges(model.dagEdges);
        }

        public final Collection<CodeGenNode.Builder> getDagNodes() {
            return this.dagNodes != null ? (Collection)this.dagNodes.stream().map(CodeGenNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dagNodes(Collection<CodeGenNode> dagNodes) {
            this.dagNodes = DagNodesCopier.copy(dagNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(CodeGenNode ... dagNodes) {
            this.dagNodes(Arrays.asList(dagNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(Consumer<CodeGenNode.Builder> ... dagNodes) {
            this.dagNodes(Stream.of(dagNodes).map(c -> (CodeGenNode)((CodeGenNode.Builder)CodeGenNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDagNodes(Collection<CodeGenNode.BuilderImpl> dagNodes) {
            this.dagNodes = DagNodesCopier.copyFromBuilder(dagNodes);
        }

        public final Collection<CodeGenEdge.Builder> getDagEdges() {
            return this.dagEdges != null ? (Collection)this.dagEdges.stream().map(CodeGenEdge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dagEdges(Collection<CodeGenEdge> dagEdges) {
            this.dagEdges = DagEdgesCopier.copy(dagEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(CodeGenEdge ... dagEdges) {
            this.dagEdges(Arrays.asList(dagEdges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(Consumer<CodeGenEdge.Builder> ... dagEdges) {
            this.dagEdges(Stream.of(dagEdges).map(c -> (CodeGenEdge)((CodeGenEdge.Builder)CodeGenEdge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDagEdges(Collection<CodeGenEdge.BuilderImpl> dagEdges) {
            this.dagEdges = DagEdgesCopier.copyFromBuilder(dagEdges);
        }

        @Override
        public GetDataflowGraphResponse build() {
            return new GetDataflowGraphResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataflowGraphResponse> {
        public Builder dagNodes(Collection<CodeGenNode> var1);

        public Builder dagNodes(CodeGenNode ... var1);

        public Builder dagNodes(Consumer<CodeGenNode.Builder> ... var1);

        public Builder dagEdges(Collection<CodeGenEdge> var1);

        public Builder dagEdges(CodeGenEdge ... var1);

        public Builder dagEdges(Consumer<CodeGenEdge.Builder> ... var1);
    }
}

