/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMlTransformsResponse extends GlueResponse implements
        ToCopyableBuilder<ListMlTransformsResponse.Builder, ListMlTransformsResponse> {
    private static final SdkField<List<String>> TRANSFORM_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListMlTransformsResponse::transformIds))
            .setter(setter(Builder::transformIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMlTransformsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> transformIds;

    private final String nextToken;

    private ListMlTransformsResponse(BuilderImpl builder) {
        super(builder);
        this.transformIds = builder.transformIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TransformIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTransformIds() {
        return transformIds != null && !(transformIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of all the machine learning transforms in the account, or the machine learning transforms with
     * the specified tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransformIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of all the machine learning transforms in the account, or the machine learning transforms
     *         with the specified tags.
     */
    public List<String> transformIds() {
        return transformIds;
    }

    /**
     * <p>
     * A continuation token, if the returned list does not contain the last metric available.
     * </p>
     * 
     * @return A continuation token, if the returned list does not contain the last metric available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMlTransformsResponse)) {
            return false;
        }
        ListMlTransformsResponse other = (ListMlTransformsResponse) obj;
        return Objects.equals(transformIds(), other.transformIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMlTransformsResponse").add("TransformIds", transformIds()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformIds":
            return Optional.ofNullable(clazz.cast(transformIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMlTransformsResponse, T> g) {
        return obj -> g.apply((ListMlTransformsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMlTransformsResponse> {
        /**
         * <p>
         * The identifiers of all the machine learning transforms in the account, or the machine learning transforms
         * with the specified tags.
         * </p>
         * 
         * @param transformIds
         *        The identifiers of all the machine learning transforms in the account, or the machine learning
         *        transforms with the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformIds(Collection<String> transformIds);

        /**
         * <p>
         * The identifiers of all the machine learning transforms in the account, or the machine learning transforms
         * with the specified tags.
         * </p>
         * 
         * @param transformIds
         *        The identifiers of all the machine learning transforms in the account, or the machine learning
         *        transforms with the specified tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformIds(String... transformIds);

        /**
         * <p>
         * A continuation token, if the returned list does not contain the last metric available.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the returned list does not contain the last metric available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> transformIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMlTransformsResponse model) {
            super(model);
            transformIds(model.transformIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTransformIds() {
            return transformIds;
        }

        @Override
        public final Builder transformIds(Collection<String> transformIds) {
            this.transformIds = TransformIdListCopier.copy(transformIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformIds(String... transformIds) {
            transformIds(Arrays.asList(transformIds));
            return this;
        }

        public final void setTransformIds(Collection<String> transformIds) {
            this.transformIds = TransformIdListCopier.copy(transformIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMlTransformsResponse build() {
            return new ListMlTransformsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
