/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPartitionIndexesResponse extends GlueResponse implements
        ToCopyableBuilder<GetPartitionIndexesResponse.Builder, GetPartitionIndexesResponse> {
    private static final SdkField<List<PartitionIndexDescriptor>> PARTITION_INDEX_DESCRIPTOR_LIST_FIELD = SdkField
            .<List<PartitionIndexDescriptor>> builder(MarshallingType.LIST)
            .getter(getter(GetPartitionIndexesResponse::partitionIndexDescriptorList))
            .setter(setter(Builder::partitionIndexDescriptorList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIndexDescriptorList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionIndexDescriptor> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionIndexDescriptor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPartitionIndexesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PARTITION_INDEX_DESCRIPTOR_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<PartitionIndexDescriptor> partitionIndexDescriptorList;

    private final String nextToken;

    private GetPartitionIndexesResponse(BuilderImpl builder) {
        super(builder);
        this.partitionIndexDescriptorList = builder.partitionIndexDescriptorList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PartitionIndexDescriptorList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPartitionIndexDescriptorList() {
        return partitionIndexDescriptorList != null && !(partitionIndexDescriptorList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of index descriptors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitionIndexDescriptorList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of index descriptors.
     */
    public List<PartitionIndexDescriptor> partitionIndexDescriptorList() {
        return partitionIndexDescriptorList;
    }

    /**
     * <p>
     * A continuation token, present if the current list segment is not the last.
     * </p>
     * 
     * @return A continuation token, present if the current list segment is not the last.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(partitionIndexDescriptorList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionIndexesResponse)) {
            return false;
        }
        GetPartitionIndexesResponse other = (GetPartitionIndexesResponse) obj;
        return Objects.equals(partitionIndexDescriptorList(), other.partitionIndexDescriptorList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPartitionIndexesResponse")
                .add("PartitionIndexDescriptorList", partitionIndexDescriptorList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionIndexDescriptorList":
            return Optional.ofNullable(clazz.cast(partitionIndexDescriptorList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPartitionIndexesResponse, T> g) {
        return obj -> g.apply((GetPartitionIndexesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPartitionIndexesResponse> {
        /**
         * <p>
         * A list of index descriptors.
         * </p>
         * 
         * @param partitionIndexDescriptorList
         *        A list of index descriptors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionIndexDescriptorList(Collection<PartitionIndexDescriptor> partitionIndexDescriptorList);

        /**
         * <p>
         * A list of index descriptors.
         * </p>
         * 
         * @param partitionIndexDescriptorList
         *        A list of index descriptors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionIndexDescriptorList(PartitionIndexDescriptor... partitionIndexDescriptorList);

        /**
         * <p>
         * A list of index descriptors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartitionIndexDescriptor>.Builder} avoiding
         * the need to create one manually via {@link List<PartitionIndexDescriptor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartitionIndexDescriptor>.Builder#build()} is called
         * immediately and its result is passed to {@link #partitionIndexDescriptorList(List<PartitionIndexDescriptor>)}
         * .
         * 
         * @param partitionIndexDescriptorList
         *        a consumer that will call methods on {@link List<PartitionIndexDescriptor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionIndexDescriptorList(List<PartitionIndexDescriptor>)
         */
        Builder partitionIndexDescriptorList(Consumer<PartitionIndexDescriptor.Builder>... partitionIndexDescriptorList);

        /**
         * <p>
         * A continuation token, present if the current list segment is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, present if the current list segment is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<PartitionIndexDescriptor> partitionIndexDescriptorList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartitionIndexesResponse model) {
            super(model);
            partitionIndexDescriptorList(model.partitionIndexDescriptorList);
            nextToken(model.nextToken);
        }

        public final Collection<PartitionIndexDescriptor.Builder> getPartitionIndexDescriptorList() {
            return partitionIndexDescriptorList != null ? partitionIndexDescriptorList.stream()
                    .map(PartitionIndexDescriptor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionIndexDescriptorList(Collection<PartitionIndexDescriptor> partitionIndexDescriptorList) {
            this.partitionIndexDescriptorList = PartitionIndexDescriptorListCopier.copy(partitionIndexDescriptorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexDescriptorList(PartitionIndexDescriptor... partitionIndexDescriptorList) {
            partitionIndexDescriptorList(Arrays.asList(partitionIndexDescriptorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexDescriptorList(
                Consumer<PartitionIndexDescriptor.Builder>... partitionIndexDescriptorList) {
            partitionIndexDescriptorList(Stream.of(partitionIndexDescriptorList)
                    .map(c -> PartitionIndexDescriptor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitionIndexDescriptorList(
                Collection<PartitionIndexDescriptor.BuilderImpl> partitionIndexDescriptorList) {
            this.partitionIndexDescriptorList = PartitionIndexDescriptorListCopier.copyFromBuilder(partitionIndexDescriptorList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetPartitionIndexesResponse build() {
            return new GetPartitionIndexesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
