/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlTaskRunsResponse extends GlueResponse implements
        ToCopyableBuilder<GetMlTaskRunsResponse.Builder, GetMlTaskRunsResponse> {
    private static final SdkField<List<TaskRun>> TASK_RUNS_FIELD = SdkField
            .<List<TaskRun>> builder(MarshallingType.LIST)
            .getter(getter(GetMlTaskRunsResponse::taskRuns))
            .setter(setter(Builder::taskRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMlTaskRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_RUNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TaskRun> taskRuns;

    private final String nextToken;

    private GetMlTaskRunsResponse(BuilderImpl builder) {
        super(builder);
        this.taskRuns = builder.taskRuns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TaskRuns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTaskRuns() {
        return taskRuns != null && !(taskRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of task runs that are associated with the transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTaskRuns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of task runs that are associated with the transform.
     */
    public List<TaskRun> taskRuns() {
        return taskRuns;
    }

    /**
     * <p>
     * A pagination token, if more results are available.
     * </p>
     * 
     * @return A pagination token, if more results are available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskRuns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTaskRunsResponse)) {
            return false;
        }
        GetMlTaskRunsResponse other = (GetMlTaskRunsResponse) obj;
        return Objects.equals(taskRuns(), other.taskRuns()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMlTaskRunsResponse").add("TaskRuns", taskRuns()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskRuns":
            return Optional.ofNullable(clazz.cast(taskRuns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlTaskRunsResponse, T> g) {
        return obj -> g.apply((GetMlTaskRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMlTaskRunsResponse> {
        /**
         * <p>
         * A list of task runs that are associated with the transform.
         * </p>
         * 
         * @param taskRuns
         *        A list of task runs that are associated with the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRuns(Collection<TaskRun> taskRuns);

        /**
         * <p>
         * A list of task runs that are associated with the transform.
         * </p>
         * 
         * @param taskRuns
         *        A list of task runs that are associated with the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRuns(TaskRun... taskRuns);

        /**
         * <p>
         * A list of task runs that are associated with the transform.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TaskRun>.Builder} avoiding the need to
         * create one manually via {@link List<TaskRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaskRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #taskRuns(List<TaskRun>)}.
         * 
         * @param taskRuns
         *        a consumer that will call methods on {@link List<TaskRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskRuns(List<TaskRun>)
         */
        Builder taskRuns(Consumer<TaskRun.Builder>... taskRuns);

        /**
         * <p>
         * A pagination token, if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token, if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<TaskRun> taskRuns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTaskRunsResponse model) {
            super(model);
            taskRuns(model.taskRuns);
            nextToken(model.nextToken);
        }

        public final Collection<TaskRun.Builder> getTaskRuns() {
            return taskRuns != null ? taskRuns.stream().map(TaskRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taskRuns(Collection<TaskRun> taskRuns) {
            this.taskRuns = TaskRunListCopier.copy(taskRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskRuns(TaskRun... taskRuns) {
            taskRuns(Arrays.asList(taskRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskRuns(Consumer<TaskRun.Builder>... taskRuns) {
            taskRuns(Stream.of(taskRuns).map(c -> TaskRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaskRuns(Collection<TaskRun.BuilderImpl> taskRuns) {
            this.taskRuns = TaskRunListCopier.copyFromBuilder(taskRuns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetMlTaskRunsResponse build() {
            return new GetMlTaskRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
