/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataflowGraphResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataflowGraphResponse.Builder, GetDataflowGraphResponse> {
    private static final SdkField<List<CodeGenNode>> DAG_NODES_FIELD = SdkField
            .<List<CodeGenNode>> builder(MarshallingType.LIST)
            .getter(getter(GetDataflowGraphResponse::dagNodes))
            .setter(setter(Builder::dagNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeGenNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CodeGenEdge>> DAG_EDGES_FIELD = SdkField
            .<List<CodeGenEdge>> builder(MarshallingType.LIST)
            .getter(getter(GetDataflowGraphResponse::dagEdges))
            .setter(setter(Builder::dagEdges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagEdges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeGenEdge> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenEdge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_NODES_FIELD,
            DAG_EDGES_FIELD));

    private final List<CodeGenNode> dagNodes;

    private final List<CodeGenEdge> dagEdges;

    private GetDataflowGraphResponse(BuilderImpl builder) {
        super(builder);
        this.dagNodes = builder.dagNodes;
        this.dagEdges = builder.dagEdges;
    }

    /**
     * Returns true if the DagNodes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDagNodes() {
        return dagNodes != null && !(dagNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the nodes in the resulting DAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDagNodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the nodes in the resulting DAG.
     */
    public List<CodeGenNode> dagNodes() {
        return dagNodes;
    }

    /**
     * Returns true if the DagEdges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDagEdges() {
        return dagEdges != null && !(dagEdges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the edges in the resulting DAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDagEdges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the edges in the resulting DAG.
     */
    public List<CodeGenEdge> dagEdges() {
        return dagEdges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dagNodes());
        hashCode = 31 * hashCode + Objects.hashCode(dagEdges());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowGraphResponse)) {
            return false;
        }
        GetDataflowGraphResponse other = (GetDataflowGraphResponse) obj;
        return Objects.equals(dagNodes(), other.dagNodes()) && Objects.equals(dagEdges(), other.dagEdges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDataflowGraphResponse").add("DagNodes", dagNodes()).add("DagEdges", dagEdges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DagNodes":
            return Optional.ofNullable(clazz.cast(dagNodes()));
        case "DagEdges":
            return Optional.ofNullable(clazz.cast(dagEdges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowGraphResponse, T> g) {
        return obj -> g.apply((GetDataflowGraphResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataflowGraphResponse> {
        /**
         * <p>
         * A list of the nodes in the resulting DAG.
         * </p>
         * 
         * @param dagNodes
         *        A list of the nodes in the resulting DAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagNodes(Collection<CodeGenNode> dagNodes);

        /**
         * <p>
         * A list of the nodes in the resulting DAG.
         * </p>
         * 
         * @param dagNodes
         *        A list of the nodes in the resulting DAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagNodes(CodeGenNode... dagNodes);

        /**
         * <p>
         * A list of the nodes in the resulting DAG.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeGenNode>.Builder} avoiding the need to
         * create one manually via {@link List<CodeGenNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeGenNode>.Builder#build()} is called immediately and its
         * result is passed to {@link #dagNodes(List<CodeGenNode>)}.
         * 
         * @param dagNodes
         *        a consumer that will call methods on {@link List<CodeGenNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dagNodes(List<CodeGenNode>)
         */
        Builder dagNodes(Consumer<CodeGenNode.Builder>... dagNodes);

        /**
         * <p>
         * A list of the edges in the resulting DAG.
         * </p>
         * 
         * @param dagEdges
         *        A list of the edges in the resulting DAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagEdges(Collection<CodeGenEdge> dagEdges);

        /**
         * <p>
         * A list of the edges in the resulting DAG.
         * </p>
         * 
         * @param dagEdges
         *        A list of the edges in the resulting DAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dagEdges(CodeGenEdge... dagEdges);

        /**
         * <p>
         * A list of the edges in the resulting DAG.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeGenEdge>.Builder} avoiding the need to
         * create one manually via {@link List<CodeGenEdge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeGenEdge>.Builder#build()} is called immediately and its
         * result is passed to {@link #dagEdges(List<CodeGenEdge>)}.
         * 
         * @param dagEdges
         *        a consumer that will call methods on {@link List<CodeGenEdge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dagEdges(List<CodeGenEdge>)
         */
        Builder dagEdges(Consumer<CodeGenEdge.Builder>... dagEdges);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<CodeGenNode> dagNodes = DefaultSdkAutoConstructList.getInstance();

        private List<CodeGenEdge> dagEdges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowGraphResponse model) {
            super(model);
            dagNodes(model.dagNodes);
            dagEdges(model.dagEdges);
        }

        public final Collection<CodeGenNode.Builder> getDagNodes() {
            return dagNodes != null ? dagNodes.stream().map(CodeGenNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dagNodes(Collection<CodeGenNode> dagNodes) {
            this.dagNodes = DagNodesCopier.copy(dagNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(CodeGenNode... dagNodes) {
            dagNodes(Arrays.asList(dagNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(Consumer<CodeGenNode.Builder>... dagNodes) {
            dagNodes(Stream.of(dagNodes).map(c -> CodeGenNode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDagNodes(Collection<CodeGenNode.BuilderImpl> dagNodes) {
            this.dagNodes = DagNodesCopier.copyFromBuilder(dagNodes);
        }

        public final Collection<CodeGenEdge.Builder> getDagEdges() {
            return dagEdges != null ? dagEdges.stream().map(CodeGenEdge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dagEdges(Collection<CodeGenEdge> dagEdges) {
            this.dagEdges = DagEdgesCopier.copy(dagEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(CodeGenEdge... dagEdges) {
            dagEdges(Arrays.asList(dagEdges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(Consumer<CodeGenEdge.Builder>... dagEdges) {
            dagEdges(Stream.of(dagEdges).map(c -> CodeGenEdge.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDagEdges(Collection<CodeGenEdge.BuilderImpl> dagEdges) {
            this.dagEdges = DagEdgesCopier.copyFromBuilder(dagEdges);
        }

        @Override
        public GetDataflowGraphResponse build() {
            return new GetDataflowGraphResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
