/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCrawlersRequest extends GlueRequest implements
        ToCopyableBuilder<BatchGetCrawlersRequest.Builder, BatchGetCrawlersRequest> {
    private static final SdkField<List<String>> CRAWLER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetCrawlersRequest::crawlerNames))
            .setter(setter(Builder::crawlerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAMES_FIELD));

    private final List<String> crawlerNames;

    private BatchGetCrawlersRequest(BuilderImpl builder) {
        super(builder);
        this.crawlerNames = builder.crawlerNames;
    }

    /**
     * Returns true if the CrawlerNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCrawlerNames() {
        return crawlerNames != null && !(crawlerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of crawler names, which might be the names returned from the <code>ListCrawlers</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCrawlerNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of crawler names, which might be the names returned from the <code>ListCrawlers</code> operation.
     */
    public List<String> crawlerNames() {
        return crawlerNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crawlerNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCrawlersRequest)) {
            return false;
        }
        BatchGetCrawlersRequest other = (BatchGetCrawlersRequest) obj;
        return Objects.equals(crawlerNames(), other.crawlerNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetCrawlersRequest").add("CrawlerNames", crawlerNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlerNames":
            return Optional.ofNullable(clazz.cast(crawlerNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCrawlersRequest, T> g) {
        return obj -> g.apply((BatchGetCrawlersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCrawlersRequest> {
        /**
         * <p>
         * A list of crawler names, which might be the names returned from the <code>ListCrawlers</code> operation.
         * </p>
         * 
         * @param crawlerNames
         *        A list of crawler names, which might be the names returned from the <code>ListCrawlers</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerNames(Collection<String> crawlerNames);

        /**
         * <p>
         * A list of crawler names, which might be the names returned from the <code>ListCrawlers</code> operation.
         * </p>
         * 
         * @param crawlerNames
         *        A list of crawler names, which might be the names returned from the <code>ListCrawlers</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerNames(String... crawlerNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private List<String> crawlerNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCrawlersRequest model) {
            super(model);
            crawlerNames(model.crawlerNames);
        }

        public final Collection<String> getCrawlerNames() {
            return crawlerNames;
        }

        @Override
        public final Builder crawlerNames(Collection<String> crawlerNames) {
            this.crawlerNames = CrawlerNameListCopier.copy(crawlerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerNames(String... crawlerNames) {
            crawlerNames(Arrays.asList(crawlerNames));
            return this;
        }

        public final void setCrawlerNames(Collection<String> crawlerNames) {
            this.crawlerNames = CrawlerNameListCopier.copy(crawlerNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCrawlersRequest build() {
            return new BatchGetCrawlersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
