/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteConnectionRequest extends GlueRequest implements
        ToCopyableBuilder<BatchDeleteConnectionRequest.Builder, BatchDeleteConnectionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDeleteConnectionRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<List<String>> CONNECTION_NAME_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchDeleteConnectionRequest::connectionNameList))
            .setter(setter(Builder::connectionNameList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNameList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            CONNECTION_NAME_LIST_FIELD));

    private final String catalogId;

    private final List<String> connectionNameList;

    private BatchDeleteConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.connectionNameList = builder.connectionNameList;
    }

    /**
     * <p>
     * The ID of the Data Catalog in which the connections reside. If none is provided, the AWS account ID is used by
     * default.
     * </p>
     * 
     * @return The ID of the Data Catalog in which the connections reside. If none is provided, the AWS account ID is
     *         used by default.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * Returns true if the ConnectionNameList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConnectionNameList() {
        return connectionNameList != null && !(connectionNameList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of the connections to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectionNameList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of the connections to delete.
     */
    public List<String> connectionNameList() {
        return connectionNameList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionNameList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteConnectionRequest)) {
            return false;
        }
        BatchDeleteConnectionRequest other = (BatchDeleteConnectionRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(connectionNameList(), other.connectionNameList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDeleteConnectionRequest").add("CatalogId", catalogId())
                .add("ConnectionNameList", connectionNameList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "ConnectionNameList":
            return Optional.ofNullable(clazz.cast(connectionNameList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteConnectionRequest, T> g) {
        return obj -> g.apply((BatchDeleteConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteConnectionRequest> {
        /**
         * <p>
         * The ID of the Data Catalog in which the connections reside. If none is provided, the AWS account ID is used
         * by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog in which the connections reside. If none is provided, the AWS account ID is
         *        used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A list of names of the connections to delete.
         * </p>
         * 
         * @param connectionNameList
         *        A list of names of the connections to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNameList(Collection<String> connectionNameList);

        /**
         * <p>
         * A list of names of the connections to delete.
         * </p>
         * 
         * @param connectionNameList
         *        A list of names of the connections to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNameList(String... connectionNameList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private List<String> connectionNameList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteConnectionRequest model) {
            super(model);
            catalogId(model.catalogId);
            connectionNameList(model.connectionNameList);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final Collection<String> getConnectionNameList() {
            return connectionNameList;
        }

        @Override
        public final Builder connectionNameList(Collection<String> connectionNameList) {
            this.connectionNameList = DeleteConnectionNameListCopier.copy(connectionNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNameList(String... connectionNameList) {
            connectionNameList(Arrays.asList(connectionNameList));
            return this;
        }

        public final void setConnectionNameList(Collection<String> connectionNameList) {
            this.connectionNameList = DeleteConnectionNameListCopier.copy(connectionNameList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteConnectionRequest build() {
            return new BatchDeleteConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
