/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an action to be initiated by a trigger.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Action::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Action::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Action::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Action::securityConfiguration)).setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField
            .<NotificationProperty> builder(MarshallingType.SDK_POJO).getter(getter(Action::notificationProperty))
            .setter(setter(Builder::notificationProperty)).constructor(NotificationProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build())
            .build();

    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Action::crawlerName)).setter(setter(Builder::crawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            ARGUMENTS_FIELD, TIMEOUT_FIELD, SECURITY_CONFIGURATION_FIELD, NOTIFICATION_PROPERTY_FIELD, CRAWLER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final Map<String, String> arguments;

    private final Integer timeout;

    private final String securityConfiguration;

    private final NotificationProperty notificationProperty;

    private final String crawlerName;

    private Action(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.arguments = builder.arguments;
        this.timeout = builder.timeout;
        this.securityConfiguration = builder.securityConfiguration;
        this.notificationProperty = builder.notificationProperty;
        this.crawlerName = builder.crawlerName;
    }

    /**
     * <p>
     * The name of a job to be executed.
     * </p>
     * 
     * @return The name of a job to be executed.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * Returns true if the Arguments property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the
     * job definition itself.
     * </p>
     * <p>
     * You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue
     * itself consumes.
     * </p>
     * <p>
     * For information about how to specify and consume your own Job arguments, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs
     * in Python</a> topic in the developer guide.
     * </p>
     * <p>
     * For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters
     * Used by AWS Glue</a> topic in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArguments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The job arguments used when this trigger fires. For this job run, they replace the default arguments set
     *         in the job definition itself.</p>
     *         <p>
     *         You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS
     *         Glue itself consumes.
     *         </p>
     *         <p>
     *         For information about how to specify and consume your own Job arguments, see the <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS
     *         Glue APIs in Python</a> topic in the developer guide.
     *         </p>
     *         <p>
     *         For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
     *         Parameters Used by AWS Glue</a> topic in the developer guide.
     */
    public Map<String, String> arguments() {
        return arguments;
    }

    /**
     * <p>
     * The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources before
     * it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This overrides
     * the timeout value set in the parent job.
     * </p>
     * 
     * @return The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources
     *         before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     *         This overrides the timeout value set in the parent job.
     */
    public Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure to be used with this action.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure to be used with this action.
     */
    public String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * Specifies configuration properties of a job run notification.
     * </p>
     * 
     * @return Specifies configuration properties of a job run notification.
     */
    public NotificationProperty notificationProperty() {
        return notificationProperty;
    }

    /**
     * <p>
     * The name of the crawler to be used with this action.
     * </p>
     * 
     * @return The name of the crawler to be used with this action.
     */
    public String crawlerName() {
        return crawlerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(arguments());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(arguments(), other.arguments())
                && Objects.equals(timeout(), other.timeout())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(notificationProperty(), other.notificationProperty())
                && Objects.equals(crawlerName(), other.crawlerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Action").add("JobName", jobName()).add("Arguments", arguments()).add("Timeout", timeout())
                .add("SecurityConfiguration", securityConfiguration()).add("NotificationProperty", notificationProperty())
                .add("CrawlerName", crawlerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "NotificationProperty":
            return Optional.ofNullable(clazz.cast(notificationProperty()));
        case "CrawlerName":
            return Optional.ofNullable(clazz.cast(crawlerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The name of a job to be executed.
         * </p>
         * 
         * @param jobName
         *        The name of a job to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job arguments used when this trigger fires. For this job run, they replace the default arguments set in
         * the job definition itself.
         * </p>
         * <p>
         * You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS
         * Glue itself consumes.
         * </p>
         * <p>
         * For information about how to specify and consume your own Job arguments, see the <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue
         * APIs in Python</a> topic in the developer guide.
         * </p>
         * <p>
         * For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
         * Parameters Used by AWS Glue</a> topic in the developer guide.
         * </p>
         * 
         * @param arguments
         *        The job arguments used when this trigger fires. For this job run, they replace the default arguments
         *        set in the job definition itself.</p>
         *        <p>
         *        You can specify arguments here that your own job-execution script consumes, as well as arguments that
         *        AWS Glue itself consumes.
         *        </p>
         *        <p>
         *        For information about how to specify and consume your own Job arguments, see the <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS
         *        Glue APIs in Python</a> topic in the developer guide.
         *        </p>
         *        <p>
         *        For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special
         *        Parameters Used by AWS Glue</a> topic in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);

        /**
         * <p>
         * The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources
         * before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This
         * overrides the timeout value set in the parent job.
         * </p>
         * 
         * @param timeout
         *        The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume
         *        resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes
         *        (48 hours). This overrides the timeout value set in the parent job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure to be used with this action.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure to be used with this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * Specifies configuration properties of a job run notification.
         * </p>
         * 
         * @param notificationProperty
         *        Specifies configuration properties of a job run notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationProperty(NotificationProperty notificationProperty);

        /**
         * <p>
         * Specifies configuration properties of a job run notification.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationProperty.Builder} avoiding the need
         * to create one manually via {@link NotificationProperty#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationProperty(NotificationProperty)}.
         * 
         * @param notificationProperty
         *        a consumer that will call methods on {@link NotificationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationProperty(NotificationProperty)
         */
        default Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return notificationProperty(NotificationProperty.builder().applyMutation(notificationProperty).build());
        }

        /**
         * <p>
         * The name of the crawler to be used with this action.
         * </p>
         * 
         * @param crawlerName
         *        The name of the crawler to be used with this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerName(String crawlerName);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeout;

        private String securityConfiguration;

        private NotificationProperty notificationProperty;

        private String crawlerName;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            jobName(model.jobName);
            arguments(model.arguments);
            timeout(model.timeout);
            securityConfiguration(model.securityConfiguration);
            notificationProperty(model.notificationProperty);
            crawlerName(model.crawlerName);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Map<String, String> getArguments() {
            return arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return notificationProperty != null ? notificationProperty.toBuilder() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        public final String getCrawlerName() {
            return crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
