/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Workflow;
import software.amazon.awssdk.services.glue.model.WorkflowNamesCopier;
import software.amazon.awssdk.services.glue.model.WorkflowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetWorkflowsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetWorkflowsResponse> {
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetWorkflowsResponse.getter(BatchGetWorkflowsResponse::workflows)).setter(BatchGetWorkflowsResponse.setter(Builder::workflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MISSING_WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetWorkflowsResponse.getter(BatchGetWorkflowsResponse::missingWorkflows)).setter(BatchGetWorkflowsResponse.setter(Builder::missingWorkflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingWorkflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOWS_FIELD, MISSING_WORKFLOWS_FIELD));
    private final List<Workflow> workflows;
    private final List<String> missingWorkflows;

    private BatchGetWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.workflows = builder.workflows;
        this.missingWorkflows = builder.missingWorkflows;
    }

    public boolean hasWorkflows() {
        return this.workflows != null && !(this.workflows instanceof SdkAutoConstructList);
    }

    public List<Workflow> workflows() {
        return this.workflows;
    }

    public boolean hasMissingWorkflows() {
        return this.missingWorkflows != null && !(this.missingWorkflows instanceof SdkAutoConstructList);
    }

    public List<String> missingWorkflows() {
        return this.missingWorkflows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflows());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingWorkflows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetWorkflowsResponse)) {
            return false;
        }
        BatchGetWorkflowsResponse other = (BatchGetWorkflowsResponse)((Object)obj);
        return Objects.equals(this.workflows(), other.workflows()) && Objects.equals(this.missingWorkflows(), other.missingWorkflows());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetWorkflowsResponse").add("Workflows", this.workflows()).add("MissingWorkflows", this.missingWorkflows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Workflows": {
                return Optional.ofNullable(clazz.cast(this.workflows()));
            }
            case "MissingWorkflows": {
                return Optional.ofNullable(clazz.cast(this.missingWorkflows()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetWorkflowsResponse, T> g) {
        return obj -> g.apply((BatchGetWorkflowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();
        private List<String> missingWorkflows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetWorkflowsResponse model) {
            super(model);
            this.workflows(model.workflows);
            this.missingWorkflows(model.missingWorkflows);
        }

        public final Collection<Workflow.Builder> getWorkflows() {
            return this.workflows != null ? (Collection)this.workflows.stream().map(Workflow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowsCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow ... workflows) {
            this.workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder> ... workflows) {
            this.workflows(Stream.of(workflows).map(c -> (Workflow)((Workflow.Builder)Workflow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowsCopier.copyFromBuilder(workflows);
        }

        public final Collection<String> getMissingWorkflows() {
            return this.missingWorkflows;
        }

        @Override
        public final Builder missingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingWorkflows(String ... missingWorkflows) {
            this.missingWorkflows(Arrays.asList(missingWorkflows));
            return this;
        }

        public final void setMissingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
        }

        @Override
        public BatchGetWorkflowsResponse build() {
            return new BatchGetWorkflowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetWorkflowsResponse> {
        public Builder workflows(Collection<Workflow> var1);

        public Builder workflows(Workflow ... var1);

        public Builder workflows(Consumer<Workflow.Builder> ... var1);

        public Builder missingWorkflows(Collection<String> var1);

        public Builder missingWorkflows(String ... var1);
    }
}

