/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sorting criteria that are associated with the machine learning transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformSortCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformSortCriteria.Builder, TransformSortCriteria> {
    private static final SdkField<String> COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransformSortCriteria::columnAsString)).setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransformSortCriteria::sortDirectionAsString)).setter(setter(Builder::sortDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD,
            SORT_DIRECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String column;

    private final String sortDirection;

    private TransformSortCriteria(BuilderImpl builder) {
        this.column = builder.column;
        this.sortDirection = builder.sortDirection;
    }

    /**
     * <p>
     * The column to be used in the sorting criteria that are associated with the machine learning transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #column} will
     * return {@link TransformSortColumnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnAsString}.
     * </p>
     * 
     * @return The column to be used in the sorting criteria that are associated with the machine learning transform.
     * @see TransformSortColumnType
     */
    public TransformSortColumnType column() {
        return TransformSortColumnType.fromValue(column);
    }

    /**
     * <p>
     * The column to be used in the sorting criteria that are associated with the machine learning transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #column} will
     * return {@link TransformSortColumnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnAsString}.
     * </p>
     * 
     * @return The column to be used in the sorting criteria that are associated with the machine learning transform.
     * @see TransformSortColumnType
     */
    public String columnAsString() {
        return column;
    }

    /**
     * <p>
     * The sort direction to be used in the sorting criteria that are associated with the machine learning transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link SortDirectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction to be used in the sorting criteria that are associated with the machine learning
     *         transform.
     * @see SortDirectionType
     */
    public SortDirectionType sortDirection() {
        return SortDirectionType.fromValue(sortDirection);
    }

    /**
     * <p>
     * The sort direction to be used in the sorting criteria that are associated with the machine learning transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link SortDirectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction to be used in the sorting criteria that are associated with the machine learning
     *         transform.
     * @see SortDirectionType
     */
    public String sortDirectionAsString() {
        return sortDirection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortDirectionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformSortCriteria)) {
            return false;
        }
        TransformSortCriteria other = (TransformSortCriteria) obj;
        return Objects.equals(columnAsString(), other.columnAsString())
                && Objects.equals(sortDirectionAsString(), other.sortDirectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransformSortCriteria").add("Column", columnAsString())
                .add("SortDirection", sortDirectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(columnAsString()));
        case "SortDirection":
            return Optional.ofNullable(clazz.cast(sortDirectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformSortCriteria, T> g) {
        return obj -> g.apply((TransformSortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformSortCriteria> {
        /**
         * <p>
         * The column to be used in the sorting criteria that are associated with the machine learning transform.
         * </p>
         * 
         * @param column
         *        The column to be used in the sorting criteria that are associated with the machine learning transform.
         * @see TransformSortColumnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformSortColumnType
         */
        Builder column(String column);

        /**
         * <p>
         * The column to be used in the sorting criteria that are associated with the machine learning transform.
         * </p>
         * 
         * @param column
         *        The column to be used in the sorting criteria that are associated with the machine learning transform.
         * @see TransformSortColumnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformSortColumnType
         */
        Builder column(TransformSortColumnType column);

        /**
         * <p>
         * The sort direction to be used in the sorting criteria that are associated with the machine learning
         * transform.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction to be used in the sorting criteria that are associated with the machine learning
         *        transform.
         * @see SortDirectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirectionType
         */
        Builder sortDirection(String sortDirection);

        /**
         * <p>
         * The sort direction to be used in the sorting criteria that are associated with the machine learning
         * transform.
         * </p>
         * 
         * @param sortDirection
         *        The sort direction to be used in the sorting criteria that are associated with the machine learning
         *        transform.
         * @see SortDirectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirectionType
         */
        Builder sortDirection(SortDirectionType sortDirection);
    }

    static final class BuilderImpl implements Builder {
        private String column;

        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformSortCriteria model) {
            column(model.column);
            sortDirection(model.sortDirection);
        }

        public final String getColumn() {
            return column;
        }

        @Override
        public final Builder column(String column) {
            this.column = column;
            return this;
        }

        @Override
        public final Builder column(TransformSortColumnType column) {
            this.column(column == null ? null : column.toString());
            return this;
        }

        public final void setColumn(String column) {
            this.column = column;
        }

        public final String getSortDirection() {
            return sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirectionType sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public TransformSortCriteria build() {
            return new TransformSortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
