/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends GlueRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> POLICY_IN_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutResourcePolicyRequest::policyInJson)).setter(setter(Builder::policyInJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInJson").build()).build();

    private static final SdkField<String> POLICY_HASH_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutResourcePolicyRequest::policyHashCondition)).setter(setter(Builder::policyHashCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHashCondition").build())
            .build();

    private static final SdkField<String> POLICY_EXISTS_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutResourcePolicyRequest::policyExistsConditionAsString))
            .setter(setter(Builder::policyExistsCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyExistsCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IN_JSON_FIELD,
            POLICY_HASH_CONDITION_FIELD, POLICY_EXISTS_CONDITION_FIELD));

    private final String policyInJson;

    private final String policyHashCondition;

    private final String policyExistsCondition;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyInJson = builder.policyInJson;
        this.policyHashCondition = builder.policyHashCondition;
        this.policyExistsCondition = builder.policyExistsCondition;
    }

    /**
     * <p>
     * Contains the policy document to set, in JSON format.
     * </p>
     * 
     * @return Contains the policy document to set, in JSON format.
     */
    public String policyInJson() {
        return policyInJson;
    }

    /**
     * <p>
     * The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its purpose is to
     * prevent concurrent modifications of a policy. Do not use this parameter if no previous policy has been set.
     * </p>
     * 
     * @return The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its
     *         purpose is to prevent concurrent modifications of a policy. Do not use this parameter if no previous
     *         policy has been set.
     */
    public String policyHashCondition() {
        return policyHashCondition;
    }

    /**
     * <p>
     * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
     * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
     * existence of a policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #policyExistsCondition} will return {@link ExistCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #policyExistsConditionAsString}.
     * </p>
     * 
     * @return A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used
     *         to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend
     *         on the existence of a policy.
     * @see ExistCondition
     */
    public ExistCondition policyExistsCondition() {
        return ExistCondition.fromValue(policyExistsCondition);
    }

    /**
     * <p>
     * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
     * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
     * existence of a policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #policyExistsCondition} will return {@link ExistCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #policyExistsConditionAsString}.
     * </p>
     * 
     * @return A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used
     *         to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend
     *         on the existence of a policy.
     * @see ExistCondition
     */
    public String policyExistsConditionAsString() {
        return policyExistsCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyInJson());
        hashCode = 31 * hashCode + Objects.hashCode(policyHashCondition());
        hashCode = 31 * hashCode + Objects.hashCode(policyExistsConditionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(policyInJson(), other.policyInJson())
                && Objects.equals(policyHashCondition(), other.policyHashCondition())
                && Objects.equals(policyExistsConditionAsString(), other.policyExistsConditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("PolicyInJson", policyInJson())
                .add("PolicyHashCondition", policyHashCondition()).add("PolicyExistsCondition", policyExistsConditionAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyInJson":
            return Optional.ofNullable(clazz.cast(policyInJson()));
        case "PolicyHashCondition":
            return Optional.ofNullable(clazz.cast(policyHashCondition()));
        case "PolicyExistsCondition":
            return Optional.ofNullable(clazz.cast(policyExistsConditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * Contains the policy document to set, in JSON format.
         * </p>
         * 
         * @param policyInJson
         *        Contains the policy document to set, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInJson(String policyInJson);

        /**
         * <p>
         * The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its purpose is
         * to prevent concurrent modifications of a policy. Do not use this parameter if no previous policy has been
         * set.
         * </p>
         * 
         * @param policyHashCondition
         *        The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its
         *        purpose is to prevent concurrent modifications of a policy. Do not use this parameter if no previous
         *        policy has been set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyHashCondition(String policyHashCondition);

        /**
         * <p>
         * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
         * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
         * existence of a policy.
         * </p>
         * 
         * @param policyExistsCondition
         *        A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is
         *        used to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will
         *        not depend on the existence of a policy.
         * @see ExistCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExistCondition
         */
        Builder policyExistsCondition(String policyExistsCondition);

        /**
         * <p>
         * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
         * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
         * existence of a policy.
         * </p>
         * 
         * @param policyExistsCondition
         *        A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is
         *        used to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will
         *        not depend on the existence of a policy.
         * @see ExistCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExistCondition
         */
        Builder policyExistsCondition(ExistCondition policyExistsCondition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String policyInJson;

        private String policyHashCondition;

        private String policyExistsCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            policyInJson(model.policyInJson);
            policyHashCondition(model.policyHashCondition);
            policyExistsCondition(model.policyExistsCondition);
        }

        public final String getPolicyInJson() {
            return policyInJson;
        }

        @Override
        public final Builder policyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
            return this;
        }

        public final void setPolicyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
        }

        public final String getPolicyHashCondition() {
            return policyHashCondition;
        }

        @Override
        public final Builder policyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
            return this;
        }

        public final void setPolicyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
        }

        public final String getPolicyExistsCondition() {
            return policyExistsCondition;
        }

        @Override
        public final Builder policyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
            return this;
        }

        @Override
        public final Builder policyExistsCondition(ExistCondition policyExistsCondition) {
            this.policyExistsCondition(policyExistsCondition == null ? null : policyExistsCondition.toString());
            return this;
        }

        public final void setPolicyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
