/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A classifier that uses <code>grok</code> patterns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrokClassifier implements SdkPojo, Serializable, ToCopyableBuilder<GrokClassifier.Builder, GrokClassifier> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrokClassifier::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrokClassifier::classification)).setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GrokClassifier::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GrokClassifier::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GrokClassifier::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> GROK_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrokClassifier::grokPattern)).setter(setter(Builder::grokPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokPattern").build()).build();

    private static final SdkField<String> CUSTOM_PATTERNS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrokClassifier::customPatterns)).setter(setter(Builder::customPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPatterns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLASSIFICATION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, VERSION_FIELD, GROK_PATTERN_FIELD,
            CUSTOM_PATTERNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String classification;

    private final Instant creationTime;

    private final Instant lastUpdated;

    private final Long version;

    private final String grokPattern;

    private final String customPatterns;

    private GrokClassifier(BuilderImpl builder) {
        this.name = builder.name;
        this.classification = builder.classification;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.version = builder.version;
        this.grokPattern = builder.grokPattern;
        this.customPatterns = builder.customPatterns;
    }

    /**
     * <p>
     * The name of the classifier.
     * </p>
     * 
     * @return The name of the classifier.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and so on.
     * </p>
     * 
     * @return An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and
     *         so on.
     */
    public String classification() {
        return classification;
    }

    /**
     * <p>
     * The time that this classifier was registered.
     * </p>
     * 
     * @return The time that this classifier was registered.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that this classifier was last updated.
     * </p>
     * 
     * @return The time that this classifier was last updated.
     */
    public Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The version of this classifier.
     * </p>
     * 
     * @return The version of this classifier.
     */
    public Long version() {
        return version;
    }

    /**
     * <p>
     * The grok pattern applied to a data store by this classifier. For more information, see built-in patterns in <a
     * href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.
     * </p>
     * 
     * @return The grok pattern applied to a data store by this classifier. For more information, see built-in patterns
     *         in <a href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom
     *         Classifiers</a>.
     */
    public String grokPattern() {
        return grokPattern;
    }

    /**
     * <p>
     * Optional custom grok patterns defined by this classifier. For more information, see custom patterns in <a
     * href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.
     * </p>
     * 
     * @return Optional custom grok patterns defined by this classifier. For more information, see custom patterns in <a
     *         href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.
     */
    public String customPatterns() {
        return customPatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(grokPattern());
        hashCode = 31 * hashCode + Objects.hashCode(customPatterns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrokClassifier)) {
            return false;
        }
        GrokClassifier other = (GrokClassifier) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(classification(), other.classification())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(version(), other.version()) && Objects.equals(grokPattern(), other.grokPattern())
                && Objects.equals(customPatterns(), other.customPatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GrokClassifier").add("Name", name()).add("Classification", classification())
                .add("CreationTime", creationTime()).add("LastUpdated", lastUpdated()).add("Version", version())
                .add("GrokPattern", grokPattern()).add("CustomPatterns", customPatterns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "GrokPattern":
            return Optional.ofNullable(clazz.cast(grokPattern()));
        case "CustomPatterns":
            return Optional.ofNullable(clazz.cast(customPatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrokClassifier, T> g) {
        return obj -> g.apply((GrokClassifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrokClassifier> {
        /**
         * <p>
         * The name of the classifier.
         * </p>
         * 
         * @param name
         *        The name of the classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and so
         * on.
         * </p>
         * 
         * @param classification
         *        An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs,
         *        and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The time that this classifier was registered.
         * </p>
         * 
         * @param creationTime
         *        The time that this classifier was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that this classifier was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The time that this classifier was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The version of this classifier.
         * </p>
         * 
         * @param version
         *        The version of this classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The grok pattern applied to a data store by this classifier. For more information, see built-in patterns in
         * <a href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.
         * </p>
         * 
         * @param grokPattern
         *        The grok pattern applied to a data store by this classifier. For more information, see built-in
         *        patterns in <a href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom
         *        Classifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grokPattern(String grokPattern);

        /**
         * <p>
         * Optional custom grok patterns defined by this classifier. For more information, see custom patterns in <a
         * href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.
         * </p>
         * 
         * @param customPatterns
         *        Optional custom grok patterns defined by this classifier. For more information, see custom patterns in
         *        <a href="http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom
         *        Classifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPatterns(String customPatterns);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String classification;

        private Instant creationTime;

        private Instant lastUpdated;

        private Long version;

        private String grokPattern;

        private String customPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(GrokClassifier model) {
            name(model.name);
            classification(model.classification);
            creationTime(model.creationTime);
            lastUpdated(model.lastUpdated);
            version(model.version);
            grokPattern(model.grokPattern);
            customPatterns(model.customPatterns);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClassification() {
            return classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getGrokPattern() {
            return grokPattern;
        }

        @Override
        public final Builder grokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public final void setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
        }

        public final String getCustomPatterns() {
            return customPatterns;
        }

        @Override
        public final Builder customPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
            return this;
        }

        public final void setCustomPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
        }

        @Override
        public GrokClassifier build() {
            return new GrokClassifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
