/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelMlTaskRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CancelMlTaskRunRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelMlTaskRunRequest.getter(CancelMlTaskRunRequest::transformId)).setter(CancelMlTaskRunRequest.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> TASK_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelMlTaskRunRequest.getter(CancelMlTaskRunRequest::taskRunId)).setter(CancelMlTaskRunRequest.setter(Builder::taskRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, TASK_RUN_ID_FIELD));
    private final String transformId;
    private final String taskRunId;

    private CancelMlTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.taskRunId = builder.taskRunId;
    }

    public String transformId() {
        return this.transformId;
    }

    public String taskRunId() {
        return this.taskRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMlTaskRunRequest)) {
            return false;
        }
        CancelMlTaskRunRequest other = (CancelMlTaskRunRequest)((Object)obj);
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.taskRunId(), other.taskRunId());
    }

    public String toString() {
        return ToString.builder((String)"CancelMlTaskRunRequest").add("TransformId", (Object)this.transformId()).add("TaskRunId", (Object)this.taskRunId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "TaskRunId": {
                return Optional.ofNullable(clazz.cast(this.taskRunId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelMlTaskRunRequest, T> g) {
        return obj -> g.apply((CancelMlTaskRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String transformId;
        private String taskRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMlTaskRunRequest model) {
            super(model);
            this.transformId(model.transformId);
            this.taskRunId(model.taskRunId);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getTaskRunId() {
            return this.taskRunId;
        }

        @Override
        public final Builder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        public final void setTaskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelMlTaskRunRequest build() {
            return new CancelMlTaskRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelMlTaskRunRequest> {
        public Builder transformId(String var1);

        public Builder taskRunId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

