/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CatalogTarget;
import software.amazon.awssdk.services.glue.model.CatalogTargetListCopier;
import software.amazon.awssdk.services.glue.model.DynamoDBTarget;
import software.amazon.awssdk.services.glue.model.DynamoDBTargetListCopier;
import software.amazon.awssdk.services.glue.model.JdbcTarget;
import software.amazon.awssdk.services.glue.model.JdbcTargetListCopier;
import software.amazon.awssdk.services.glue.model.S3Target;
import software.amazon.awssdk.services.glue.model.S3TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrawlerTargets
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrawlerTargets> {
    private static final SdkField<List<S3Target>> S3_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CrawlerTargets.getter(CrawlerTargets::s3Targets)).setter(CrawlerTargets.setter(Builder::s3Targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<JdbcTarget>> JDBC_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CrawlerTargets.getter(CrawlerTargets::jdbcTargets)).setter(CrawlerTargets.setter(Builder::jdbcTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JdbcTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JdbcTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DynamoDBTarget>> DYNAMO_DB_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CrawlerTargets.getter(CrawlerTargets::dynamoDBTargets)).setter(CrawlerTargets.setter(Builder::dynamoDBTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DynamoDBTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CatalogTarget>> CATALOG_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CrawlerTargets.getter(CrawlerTargets::catalogTargets)).setter(CrawlerTargets.setter(Builder::catalogTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CatalogTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_TARGETS_FIELD, JDBC_TARGETS_FIELD, DYNAMO_DB_TARGETS_FIELD, CATALOG_TARGETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<S3Target> s3Targets;
    private final List<JdbcTarget> jdbcTargets;
    private final List<DynamoDBTarget> dynamoDBTargets;
    private final List<CatalogTarget> catalogTargets;

    private CrawlerTargets(BuilderImpl builder) {
        this.s3Targets = builder.s3Targets;
        this.jdbcTargets = builder.jdbcTargets;
        this.dynamoDBTargets = builder.dynamoDBTargets;
        this.catalogTargets = builder.catalogTargets;
    }

    public List<S3Target> s3Targets() {
        return this.s3Targets;
    }

    public List<JdbcTarget> jdbcTargets() {
        return this.jdbcTargets;
    }

    public List<DynamoDBTarget> dynamoDBTargets() {
        return this.dynamoDBTargets;
    }

    public List<CatalogTarget> catalogTargets() {
        return this.catalogTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.jdbcTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDBTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogTargets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerTargets)) {
            return false;
        }
        CrawlerTargets other = (CrawlerTargets)obj;
        return Objects.equals(this.s3Targets(), other.s3Targets()) && Objects.equals(this.jdbcTargets(), other.jdbcTargets()) && Objects.equals(this.dynamoDBTargets(), other.dynamoDBTargets()) && Objects.equals(this.catalogTargets(), other.catalogTargets());
    }

    public String toString() {
        return ToString.builder((String)"CrawlerTargets").add("S3Targets", this.s3Targets()).add("JdbcTargets", this.jdbcTargets()).add("DynamoDBTargets", this.dynamoDBTargets()).add("CatalogTargets", this.catalogTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Targets": {
                return Optional.ofNullable(clazz.cast(this.s3Targets()));
            }
            case "JdbcTargets": {
                return Optional.ofNullable(clazz.cast(this.jdbcTargets()));
            }
            case "DynamoDBTargets": {
                return Optional.ofNullable(clazz.cast(this.dynamoDBTargets()));
            }
            case "CatalogTargets": {
                return Optional.ofNullable(clazz.cast(this.catalogTargets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlerTargets, T> g) {
        return obj -> g.apply((CrawlerTargets)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3Target> s3Targets = DefaultSdkAutoConstructList.getInstance();
        private List<JdbcTarget> jdbcTargets = DefaultSdkAutoConstructList.getInstance();
        private List<DynamoDBTarget> dynamoDBTargets = DefaultSdkAutoConstructList.getInstance();
        private List<CatalogTarget> catalogTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerTargets model) {
            this.s3Targets(model.s3Targets);
            this.jdbcTargets(model.jdbcTargets);
            this.dynamoDBTargets(model.dynamoDBTargets);
            this.catalogTargets(model.catalogTargets);
        }

        public final Collection<S3Target.Builder> getS3Targets() {
            return this.s3Targets != null ? (Collection)this.s3Targets.stream().map(S3Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Targets(Collection<S3Target> s3Targets) {
            this.s3Targets = S3TargetListCopier.copy(s3Targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Targets(S3Target ... s3Targets) {
            this.s3Targets(Arrays.asList(s3Targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Targets(Consumer<S3Target.Builder> ... s3Targets) {
            this.s3Targets(Stream.of(s3Targets).map(c -> (S3Target)((S3Target.Builder)S3Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Targets(Collection<S3Target.BuilderImpl> s3Targets) {
            this.s3Targets = S3TargetListCopier.copyFromBuilder(s3Targets);
        }

        public final Collection<JdbcTarget.Builder> getJdbcTargets() {
            return this.jdbcTargets != null ? (Collection)this.jdbcTargets.stream().map(JdbcTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jdbcTargets(Collection<JdbcTarget> jdbcTargets) {
            this.jdbcTargets = JdbcTargetListCopier.copy(jdbcTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbcTargets(JdbcTarget ... jdbcTargets) {
            this.jdbcTargets(Arrays.asList(jdbcTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbcTargets(Consumer<JdbcTarget.Builder> ... jdbcTargets) {
            this.jdbcTargets(Stream.of(jdbcTargets).map(c -> (JdbcTarget)((JdbcTarget.Builder)JdbcTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJdbcTargets(Collection<JdbcTarget.BuilderImpl> jdbcTargets) {
            this.jdbcTargets = JdbcTargetListCopier.copyFromBuilder(jdbcTargets);
        }

        public final Collection<DynamoDBTarget.Builder> getDynamoDBTargets() {
            return this.dynamoDBTargets != null ? (Collection)this.dynamoDBTargets.stream().map(DynamoDBTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dynamoDBTargets(Collection<DynamoDBTarget> dynamoDBTargets) {
            this.dynamoDBTargets = DynamoDBTargetListCopier.copy(dynamoDBTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDBTargets(DynamoDBTarget ... dynamoDBTargets) {
            this.dynamoDBTargets(Arrays.asList(dynamoDBTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDBTargets(Consumer<DynamoDBTarget.Builder> ... dynamoDBTargets) {
            this.dynamoDBTargets(Stream.of(dynamoDBTargets).map(c -> (DynamoDBTarget)((DynamoDBTarget.Builder)DynamoDBTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDynamoDBTargets(Collection<DynamoDBTarget.BuilderImpl> dynamoDBTargets) {
            this.dynamoDBTargets = DynamoDBTargetListCopier.copyFromBuilder(dynamoDBTargets);
        }

        public final Collection<CatalogTarget.Builder> getCatalogTargets() {
            return this.catalogTargets != null ? (Collection)this.catalogTargets.stream().map(CatalogTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder catalogTargets(Collection<CatalogTarget> catalogTargets) {
            this.catalogTargets = CatalogTargetListCopier.copy(catalogTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogTargets(CatalogTarget ... catalogTargets) {
            this.catalogTargets(Arrays.asList(catalogTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogTargets(Consumer<CatalogTarget.Builder> ... catalogTargets) {
            this.catalogTargets(Stream.of(catalogTargets).map(c -> (CatalogTarget)((CatalogTarget.Builder)CatalogTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCatalogTargets(Collection<CatalogTarget.BuilderImpl> catalogTargets) {
            this.catalogTargets = CatalogTargetListCopier.copyFromBuilder(catalogTargets);
        }

        public CrawlerTargets build() {
            return new CrawlerTargets(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrawlerTargets> {
        public Builder s3Targets(Collection<S3Target> var1);

        public Builder s3Targets(S3Target ... var1);

        public Builder s3Targets(Consumer<S3Target.Builder> ... var1);

        public Builder jdbcTargets(Collection<JdbcTarget> var1);

        public Builder jdbcTargets(JdbcTarget ... var1);

        public Builder jdbcTargets(Consumer<JdbcTarget.Builder> ... var1);

        public Builder dynamoDBTargets(Collection<DynamoDBTarget> var1);

        public Builder dynamoDBTargets(DynamoDBTarget ... var1);

        public Builder dynamoDBTargets(Consumer<DynamoDBTarget.Builder> ... var1);

        public Builder catalogTargets(Collection<CatalogTarget> var1);

        public Builder catalogTargets(CatalogTarget ... var1);

        public Builder catalogTargets(Consumer<CatalogTarget.Builder> ... var1);
    }
}

