/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Connection;
import software.amazon.awssdk.services.glue.model.ConnectionListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetConnectionsResponse> {
    private static final SdkField<List<Connection>> CONNECTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetConnectionsResponse.getter(GetConnectionsResponse::connectionList)).setter(GetConnectionsResponse.setter(Builder::connectionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Connection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetConnectionsResponse.getter(GetConnectionsResponse::nextToken)).setter(GetConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Connection> connectionList;
    private final String nextToken;

    private GetConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.connectionList = builder.connectionList;
        this.nextToken = builder.nextToken;
    }

    public List<Connection> connectionList() {
        return this.connectionList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsResponse)) {
            return false;
        }
        GetConnectionsResponse other = (GetConnectionsResponse)((Object)obj);
        return Objects.equals(this.connectionList(), other.connectionList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetConnectionsResponse").add("ConnectionList", this.connectionList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionList": {
                return Optional.ofNullable(clazz.cast(this.connectionList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionsResponse, T> g) {
        return obj -> g.apply((GetConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Connection> connectionList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionsResponse model) {
            super(model);
            this.connectionList(model.connectionList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Connection.Builder> getConnectionList() {
            return this.connectionList != null ? (Collection)this.connectionList.stream().map(Connection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectionList(Collection<Connection> connectionList) {
            this.connectionList = ConnectionListCopier.copy(connectionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionList(Connection ... connectionList) {
            this.connectionList(Arrays.asList(connectionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionList(Consumer<Connection.Builder> ... connectionList) {
            this.connectionList(Stream.of(connectionList).map(c -> (Connection)((Connection.Builder)Connection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionList(Collection<Connection.BuilderImpl> connectionList) {
            this.connectionList = ConnectionListCopier.copyFromBuilder(connectionList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetConnectionsResponse build() {
            return new GetConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionsResponse> {
        public Builder connectionList(Collection<Connection> var1);

        public Builder connectionList(Connection ... var1);

        public Builder connectionList(Consumer<Connection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

