/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.XMLClassifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class XMLClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").isBinary(false).build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<String> ROWTAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowTag").isBinary(false).build();
    private static final XMLClassifierMarshaller INSTANCE = new XMLClassifierMarshaller();

    private XMLClassifierMarshaller() {
    }

    public static XMLClassifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(XMLClassifier xmlClassifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)xmlClassifier, (String)"xmlClassifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)xmlClassifier.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)xmlClassifier.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)xmlClassifier.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)xmlClassifier.lastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)xmlClassifier.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)xmlClassifier.rowTag(), ROWTAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

