/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Job;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUri").isBinary(false).build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedOn").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONPROPERTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionProperty").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Command").isBinary(false).build();
    private static final MarshallingInfo<Map> DEFAULTARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultArguments").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Connections").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRetries").isBinary(false).build();
    private static final MarshallingInfo<Integer> ALLOCATEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedCapacity").isBinary(false).build();
    private static final JobMarshaller INSTANCE = new JobMarshaller();

    private JobMarshaller() {
    }

    public static JobMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Job job, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)job, (String)"job");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)job.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)job.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)job.logUri(), LOGURI_BINDING);
            protocolMarshaller.marshall((Object)job.role(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)job.createdOn(), CREATEDON_BINDING);
            protocolMarshaller.marshall((Object)job.lastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall((Object)job.executionProperty(), EXECUTIONPROPERTY_BINDING);
            protocolMarshaller.marshall((Object)job.command(), COMMAND_BINDING);
            protocolMarshaller.marshall(job.defaultArguments(), DEFAULTARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)job.connections(), CONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)job.maxRetries(), MAXRETRIES_BINDING);
            protocolMarshaller.marshall((Object)job.allocatedCapacity(), ALLOCATEDCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

