/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetPartitionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<List> PARTITIONVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionValues").isBinary(false).build();
    private static final GetPartitionRequestModelMarshaller INSTANCE = new GetPartitionRequestModelMarshaller();

    private GetPartitionRequestModelMarshaller() {
    }

    public static GetPartitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetPartitionRequest getPartitionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getPartitionRequest), (String)"getPartitionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getPartitionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)getPartitionRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)getPartitionRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(getPartitionRequest.partitionValues(), PARTITIONVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

