/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchStopJobRunRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<List> JOBRUNIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobRunIds").isBinary(false).build();
    private static final BatchStopJobRunRequestModelMarshaller INSTANCE = new BatchStopJobRunRequestModelMarshaller();

    private BatchStopJobRunRequestModelMarshaller() {
    }

    public static BatchStopJobRunRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchStopJobRunRequest batchStopJobRunRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchStopJobRunRequest), (String)"batchStopJobRunRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchStopJobRunRequest.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall(batchStopJobRunRequest.jobRunIds(), JOBRUNIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

