/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDeletePartitionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<List> PARTITIONSTODELETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionsToDelete").isBinary(false).build();
    private static final BatchDeletePartitionRequestModelMarshaller INSTANCE = new BatchDeletePartitionRequestModelMarshaller();

    private BatchDeletePartitionRequestModelMarshaller() {
    }

    public static BatchDeletePartitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDeletePartitionRequest batchDeletePartitionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchDeletePartitionRequest), (String)"batchDeletePartitionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchDeletePartitionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)batchDeletePartitionRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)batchDeletePartitionRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(batchDeletePartitionRequest.partitionsToDelete(), PARTITIONSTODELETE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

