/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;

public class GetTriggersIterable
implements SdkIterable<GetTriggersResponse> {
    private final GlueClient client;
    private final GetTriggersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTriggersIterable(GlueClient client, GetTriggersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTriggersResponseFetcher();
    }

    public Iterator<GetTriggersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetTriggersIterable resume(GetTriggersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetTriggersIterable(this.client, (GetTriggersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetTriggersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetTriggersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetTriggersResponseFetcher
    implements SyncPageFetcher<GetTriggersResponse> {
        private GetTriggersResponseFetcher() {
        }

        public boolean hasNextPage(GetTriggersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetTriggersResponse nextPage(GetTriggersResponse previousPage) {
            if (previousPage == null) {
                return GetTriggersIterable.this.client.getTriggers(GetTriggersIterable.this.firstRequest);
            }
            return GetTriggersIterable.this.client.getTriggers((GetTriggersRequest)((Object)GetTriggersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

