/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;

public class GetTablesIterable
implements SdkIterable<GetTablesResponse> {
    private final GlueClient client;
    private final GetTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTablesIterable(GlueClient client, GetTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTablesResponseFetcher();
    }

    public Iterator<GetTablesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetTablesIterable resume(GetTablesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetTablesIterable(this.client, (GetTablesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetTablesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetTablesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetTablesResponseFetcher
    implements SyncPageFetcher<GetTablesResponse> {
        private GetTablesResponseFetcher() {
        }

        public boolean hasNextPage(GetTablesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetTablesResponse nextPage(GetTablesResponse previousPage) {
            if (previousPage == null) {
                return GetTablesIterable.this.client.getTables(GetTablesIterable.this.firstRequest);
            }
            return GetTablesIterable.this.client.getTables((GetTablesRequest)((Object)GetTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

