/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;

public class GetPartitionsIterable
implements SdkIterable<GetPartitionsResponse> {
    private final GlueClient client;
    private final GetPartitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPartitionsIterable(GlueClient client, GetPartitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetPartitionsResponseFetcher();
    }

    public Iterator<GetPartitionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetPartitionsIterable resume(GetPartitionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetPartitionsIterable(this.client, (GetPartitionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetPartitionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetPartitionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetPartitionsResponseFetcher
    implements SyncPageFetcher<GetPartitionsResponse> {
        private GetPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetPartitionsResponse nextPage(GetPartitionsResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionsIterable.this.client.getPartitions(GetPartitionsIterable.this.firstRequest);
            }
            return GetPartitionsIterable.this.client.getPartitions((GetPartitionsRequest)((Object)GetPartitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

