/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;

public class GetJobsIterable
implements SdkIterable<GetJobsResponse> {
    private final GlueClient client;
    private final GetJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetJobsIterable(GlueClient client, GetJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetJobsResponseFetcher();
    }

    public Iterator<GetJobsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetJobsIterable resume(GetJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetJobsIterable(this.client, (GetJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetJobsResponseFetcher
    implements SyncPageFetcher<GetJobsResponse> {
        private GetJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetJobsResponse nextPage(GetJobsResponse previousPage) {
            if (previousPage == null) {
                return GetJobsIterable.this.client.getJobs(GetJobsIterable.this.firstRequest);
            }
            return GetJobsIterable.this.client.getJobs((GetJobsRequest)((Object)GetJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

