/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;

public class GetClassifiersPublisher
implements SdkPublisher<GetClassifiersResponse> {
    private final GlueAsyncClient client;
    private final GetClassifiersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetClassifiersPublisher(GlueAsyncClient client, GetClassifiersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetClassifiersPublisher(GlueAsyncClient client, GetClassifiersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetClassifiersResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetClassifiersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetClassifiersPublisher resume(GetClassifiersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetClassifiersPublisher(this.client, (GetClassifiersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetClassifiersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetClassifiersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetClassifiersResponseFetcher
    implements AsyncPageFetcher<GetClassifiersResponse> {
        private GetClassifiersResponseFetcher() {
        }

        public boolean hasNextPage(GetClassifiersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetClassifiersResponse> nextPage(GetClassifiersResponse previousPage) {
            if (previousPage == null) {
                return GetClassifiersPublisher.this.client.getClassifiers(GetClassifiersPublisher.this.firstRequest);
            }
            return GetClassifiersPublisher.this.client.getClassifiers((GetClassifiersRequest)((Object)GetClassifiersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

