/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.LastCrawlStatus;
import software.amazon.awssdk.services.glue.transform.LastCrawlInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LastCrawlInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, LastCrawlInfo> {
    private final String status;
    private final String errorMessage;
    private final String logGroup;
    private final String logStream;
    private final String messagePrefix;
    private final Instant startTime;

    private LastCrawlInfo(BuilderImpl builder) {
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
        this.messagePrefix = builder.messagePrefix;
        this.startTime = builder.startTime;
    }

    public LastCrawlStatus status() {
        return LastCrawlStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String logGroup() {
        return this.logGroup;
    }

    public String logStream() {
        return this.logStream;
    }

    public String messagePrefix() {
        return this.messagePrefix;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.messagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastCrawlInfo)) {
            return false;
        }
        LastCrawlInfo other = (LastCrawlInfo)obj;
        return Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.logGroup(), other.logGroup()) && Objects.equals(this.logStream(), other.logStream()) && Objects.equals(this.messagePrefix(), other.messagePrefix()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"LastCrawlInfo").add("Status", (Object)this.statusString()).add("ErrorMessage", (Object)this.errorMessage()).add("LogGroup", (Object)this.logGroup()).add("LogStream", (Object)this.logStream()).add("MessagePrefix", (Object)this.messagePrefix()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
            case "LogGroup": {
                return Optional.of(clazz.cast(this.logGroup()));
            }
            case "LogStream": {
                return Optional.of(clazz.cast(this.logStream()));
            }
            case "MessagePrefix": {
                return Optional.of(clazz.cast(this.messagePrefix()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LastCrawlInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String errorMessage;
        private String logGroup;
        private String logStream;
        private String messagePrefix;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastCrawlInfo model) {
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.logGroup(model.logGroup);
            this.logStream(model.logStream);
            this.messagePrefix(model.messagePrefix);
            this.startTime(model.startTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LastCrawlStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        public final String getMessagePrefix() {
            return this.messagePrefix;
        }

        @Override
        public final Builder messagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public final void setMessagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public LastCrawlInfo build() {
            return new LastCrawlInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LastCrawlInfo> {
        public Builder status(String var1);

        public Builder status(LastCrawlStatus var1);

        public Builder errorMessage(String var1);

        public Builder logGroup(String var1);

        public Builder logStream(String var1);

        public Builder messagePrefix(String var1);

        public Builder startTime(Instant var1);
    }
}

