/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ConnectionsList;
import software.amazon.awssdk.services.glue.model.ExecutionProperty;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.JobCommand;
import software.amazon.awssdk.services.glue.transform.JobMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Job
implements StructuredPojo,
ToCopyableBuilder<Builder, Job> {
    private final String name;
    private final String description;
    private final String logUri;
    private final String role;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final ExecutionProperty executionProperty;
    private final JobCommand command;
    private final Map<String, String> defaultArguments;
    private final ConnectionsList connections;
    private final Integer maxRetries;
    private final Integer allocatedCapacity;

    private Job(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.logUri = builder.logUri;
        this.role = builder.role;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.executionProperty = builder.executionProperty;
        this.command = builder.command;
        this.defaultArguments = builder.defaultArguments;
        this.connections = builder.connections;
        this.maxRetries = builder.maxRetries;
        this.allocatedCapacity = builder.allocatedCapacity;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String logUri() {
        return this.logUri;
    }

    public String role() {
        return this.role;
    }

    public Instant createdOn() {
        return this.createdOn;
    }

    public Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public ExecutionProperty executionProperty() {
        return this.executionProperty;
    }

    public JobCommand command() {
        return this.command;
    }

    public Map<String, String> defaultArguments() {
        return this.defaultArguments;
    }

    public ConnectionsList connections() {
        return this.connections;
    }

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultArguments());
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.executionProperty(), other.executionProperty()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.defaultArguments(), other.defaultArguments()) && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"Job").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LogUri", (Object)this.logUri()).add("Role", (Object)this.role()).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("ExecutionProperty", (Object)this.executionProperty()).add("Command", (Object)this.command()).add("DefaultArguments", this.defaultArguments()).add("Connections", (Object)this.connections()).add("MaxRetries", (Object)this.maxRetries()).add("AllocatedCapacity", (Object)this.allocatedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "Role": {
                return Optional.of(clazz.cast(this.role()));
            }
            case "CreatedOn": {
                return Optional.of(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.of(clazz.cast(this.lastModifiedOn()));
            }
            case "ExecutionProperty": {
                return Optional.of(clazz.cast(this.executionProperty()));
            }
            case "Command": {
                return Optional.of(clazz.cast(this.command()));
            }
            case "DefaultArguments": {
                return Optional.of(clazz.cast(this.defaultArguments()));
            }
            case "Connections": {
                return Optional.of(clazz.cast(this.connections()));
            }
            case "MaxRetries": {
                return Optional.of(clazz.cast(this.maxRetries()));
            }
            case "AllocatedCapacity": {
                return Optional.of(clazz.cast(this.allocatedCapacity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String logUri;
        private String role;
        private Instant createdOn;
        private Instant lastModifiedOn;
        private ExecutionProperty executionProperty;
        private JobCommand command;
        private Map<String, String> defaultArguments;
        private ConnectionsList connections;
        private Integer maxRetries;
        private Integer allocatedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.name(model.name);
            this.description(model.description);
            this.logUri(model.logUri);
            this.role(model.role);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.executionProperty(model.executionProperty);
            this.command(model.command);
            this.defaultArguments(model.defaultArguments);
            this.connections(model.connections);
            this.maxRetries(model.maxRetries);
            this.allocatedCapacity(model.allocatedCapacity);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final ExecutionProperty.Builder getExecutionProperty() {
            return this.executionProperty != null ? this.executionProperty.toBuilder() : null;
        }

        @Override
        public final Builder executionProperty(ExecutionProperty executionProperty) {
            this.executionProperty = executionProperty;
            return this;
        }

        public final void setExecutionProperty(ExecutionProperty.BuilderImpl executionProperty) {
            this.executionProperty = executionProperty != null ? executionProperty.build() : null;
        }

        public final JobCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        @Override
        public final Builder command(JobCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(JobCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final Map<String, String> getDefaultArguments() {
            return this.defaultArguments;
        }

        @Override
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
            return this;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
        }

        public final ConnectionsList.Builder getConnections() {
            return this.connections != null ? this.connections.toBuilder() : null;
        }

        @Override
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        public Job build() {
            return new Job(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Job> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder logUri(String var1);

        public Builder role(String var1);

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder executionProperty(ExecutionProperty var1);

        default public Builder executionProperty(Consumer<ExecutionProperty.Builder> executionProperty) {
            return this.executionProperty((ExecutionProperty)((ExecutionProperty.Builder)ExecutionProperty.builder().apply(executionProperty)).build());
        }

        public Builder command(JobCommand var1);

        default public Builder command(Consumer<JobCommand.Builder> command) {
            return this.command((JobCommand)((JobCommand.Builder)JobCommand.builder().apply(command)).build());
        }

        public Builder defaultArguments(Map<String, String> var1);

        public Builder connections(ConnectionsList var1);

        default public Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return this.connections((ConnectionsList)((ConnectionsList.Builder)ConnectionsList.builder().apply(connections)).build());
        }

        public Builder maxRetries(Integer var1);

        public Builder allocatedCapacity(Integer var1);
    }
}

