/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.UserDefinedFunction;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetUserDefinedFunctionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetUserDefinedFunctionsResponse> {
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final String nextToken;

    private GetUserDefinedFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.nextToken = builder.nextToken;
    }

    public List<UserDefinedFunction> userDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userDefinedFunctions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserDefinedFunctionsResponse)) {
            return false;
        }
        GetUserDefinedFunctionsResponse other = (GetUserDefinedFunctionsResponse)((Object)obj);
        return Objects.equals(this.userDefinedFunctions(), other.userDefinedFunctions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetUserDefinedFunctionsResponse").add("UserDefinedFunctions", this.userDefinedFunctions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserDefinedFunctions": {
                return Optional.of(clazz.cast(this.userDefinedFunctions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<UserDefinedFunction> userDefinedFunctions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserDefinedFunctionsResponse model) {
            this.userDefinedFunctions(model.userDefinedFunctions);
            this.nextToken(model.nextToken);
        }

        public final Collection<UserDefinedFunction.Builder> getUserDefinedFunctions() {
            return this.userDefinedFunctions != null ? (Collection)this.userDefinedFunctions.stream().map(UserDefinedFunction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userDefinedFunctions(Collection<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = UserDefinedFunctionListCopier.copy(userDefinedFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFunctions(UserDefinedFunction ... userDefinedFunctions) {
            this.userDefinedFunctions(Arrays.asList(userDefinedFunctions));
            return this;
        }

        public final void setUserDefinedFunctions(Collection<UserDefinedFunction.BuilderImpl> userDefinedFunctions) {
            this.userDefinedFunctions = UserDefinedFunctionListCopier.copyFromBuilder(userDefinedFunctions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetUserDefinedFunctionsResponse build() {
            return new GetUserDefinedFunctionsResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetUserDefinedFunctionsResponse> {
        public Builder userDefinedFunctions(Collection<UserDefinedFunction> var1);

        public Builder userDefinedFunctions(UserDefinedFunction ... var1);

        public Builder nextToken(String var1);
    }
}

