/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTableRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateTableRequest> {
    private final String catalogId;
    private final String databaseName;
    private final TableInput tableInput;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableInput = builder.tableInput;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public TableInput tableInput() {
        return this.tableInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableInput(), other.tableInput());
    }

    public String toString() {
        return ToString.builder((String)"CreateTableRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableInput", (Object)this.tableInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "TableInput": {
                return Optional.of(clazz.cast(this.tableInput()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private TableInput tableInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableInput(model.tableInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final TableInput.Builder getTableInput() {
            return this.tableInput != null ? this.tableInput.toBuilder() : null;
        }

        @Override
        public final Builder tableInput(TableInput tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        public final void setTableInput(TableInput.BuilderImpl tableInput) {
            this.tableInput = tableInput != null ? tableInput.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreateTableRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableInput(TableInput var1);

        default public Builder tableInput(Consumer<TableInput.Builder> tableInput) {
            return this.tableInput((TableInput)((TableInput.Builder)TableInput.builder().apply(tableInput)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

