/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.SkewedInfo;

@SdkInternalApi
public class SkewedInfoMarshaller {
    private static final MarshallingInfo<List> SKEWEDCOLUMNNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedColumnNames").build();
    private static final MarshallingInfo<List> SKEWEDCOLUMNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedColumnValues").build();
    private static final MarshallingInfo<Map> SKEWEDCOLUMNVALUELOCATIONMAPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedColumnValueLocationMaps").build();
    private static final SkewedInfoMarshaller INSTANCE = new SkewedInfoMarshaller();

    public static SkewedInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SkewedInfo skewedInfo, ProtocolMarshaller protocolMarshaller) {
        if (skewedInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(skewedInfo.skewedColumnNames(), SKEWEDCOLUMNNAMES_BINDING);
            protocolMarshaller.marshall(skewedInfo.skewedColumnValues(), SKEWEDCOLUMNVALUES_BINDING);
            protocolMarshaller.marshall(skewedInfo.skewedColumnValueLocationMaps(), SKEWEDCOLUMNVALUELOCATIONMAPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

