/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.MappingEntry;

@SdkInternalApi
public class MappingEntryMarshaller {
    private static final MarshallingInfo<String> SOURCETABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTable").build();
    private static final MarshallingInfo<String> SOURCEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourcePath").build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").build();
    private static final MarshallingInfo<String> TARGETTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetTable").build();
    private static final MarshallingInfo<String> TARGETPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetPath").build();
    private static final MarshallingInfo<String> TARGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetType").build();
    private static final MappingEntryMarshaller INSTANCE = new MappingEntryMarshaller();

    public static MappingEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MappingEntry mappingEntry, ProtocolMarshaller protocolMarshaller) {
        if (mappingEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mappingEntry.sourceTable(), SOURCETABLE_BINDING);
            protocolMarshaller.marshall((Object)mappingEntry.sourcePath(), SOURCEPATH_BINDING);
            protocolMarshaller.marshall((Object)mappingEntry.sourceType(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)mappingEntry.targetTable(), TARGETTABLE_BINDING);
            protocolMarshaller.marshall((Object)mappingEntry.targetPath(), TARGETPATH_BINDING);
            protocolMarshaller.marshall((Object)mappingEntry.targetType(), TARGETTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

