/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.JobUpdate;

@SdkInternalApi
public class JobUpdateMarshaller {
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> LOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUri").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONPROPERTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionProperty").build();
    private static final MarshallingInfo<StructuredPojo> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Command").build();
    private static final MarshallingInfo<Map> DEFAULTARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultArguments").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Connections").build();
    private static final MarshallingInfo<Integer> MAXRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRetries").build();
    private static final MarshallingInfo<Integer> ALLOCATEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedCapacity").build();
    private static final JobUpdateMarshaller INSTANCE = new JobUpdateMarshaller();

    public static JobUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobUpdate jobUpdate, ProtocolMarshaller protocolMarshaller) {
        if (jobUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobUpdate.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.logUri(), LOGURI_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.role(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.executionProperty(), EXECUTIONPROPERTY_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.command(), COMMAND_BINDING);
            protocolMarshaller.marshall(jobUpdate.defaultArguments(), DEFAULTARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.connections(), CONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.maxRetries(), MAXRETRIES_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.allocatedCapacity(), ALLOCATEDCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

