/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntry;

public class JobBookmarkEntryUnmarshaller
implements Unmarshaller<JobBookmarkEntry, JsonUnmarshallerContext> {
    private static final JobBookmarkEntryUnmarshaller INSTANCE = new JobBookmarkEntryUnmarshaller();

    public JobBookmarkEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobBookmarkEntry.Builder jobBookmarkEntryBuilder = JobBookmarkEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("JobName", targetDepth)) {
                    context.nextToken();
                    jobBookmarkEntryBuilder.jobName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    jobBookmarkEntryBuilder.version((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Run", targetDepth)) {
                    context.nextToken();
                    jobBookmarkEntryBuilder.run((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attempt", targetDepth)) {
                    context.nextToken();
                    jobBookmarkEntryBuilder.attempt((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobBookmark", targetDepth)) {
                    context.nextToken();
                    jobBookmarkEntryBuilder.jobBookmark((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobBookmarkEntry)jobBookmarkEntryBuilder.build();
    }

    public static JobBookmarkEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

