/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.GrokClassifier;

@SdkInternalApi
public class GrokClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Instant> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> GROKPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrokPattern").build();
    private static final MarshallingInfo<String> CUSTOMPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomPatterns").build();
    private static final GrokClassifierMarshaller INSTANCE = new GrokClassifierMarshaller();

    public static GrokClassifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GrokClassifier grokClassifier, ProtocolMarshaller protocolMarshaller) {
        if (grokClassifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)grokClassifier.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.lastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.grokPattern(), GROKPATTERN_BINDING);
            protocolMarshaller.marshall((Object)grokClassifier.customPatterns(), CUSTOMPATTERNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

