/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;

@SdkInternalApi
public class CreatePartitionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<StructuredPojo> PARTITIONINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionInput").build();
    private static final CreatePartitionRequestModelMarshaller INSTANCE = new CreatePartitionRequestModelMarshaller();

    public static CreatePartitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreatePartitionRequest createPartitionRequest, ProtocolMarshaller protocolMarshaller) {
        if (createPartitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createPartitionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)createPartitionRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)createPartitionRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)createPartitionRequest.partitionInput(), PARTITIONINPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

