/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;

@SdkInternalApi
public class CreateDatabaseRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").build();
    private static final MarshallingInfo<StructuredPojo> DATABASEINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseInput").build();
    private static final CreateDatabaseRequestModelMarshaller INSTANCE = new CreateDatabaseRequestModelMarshaller();

    public static CreateDatabaseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDatabaseRequest createDatabaseRequest, ProtocolMarshaller protocolMarshaller) {
        if (createDatabaseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createDatabaseRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)createDatabaseRequest.databaseInput(), DATABASEINPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

