/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.ConnectionsList;

@SdkInternalApi
public class ConnectionsListMarshaller {
    private static final MarshallingInfo<List> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Connections").build();
    private static final ConnectionsListMarshaller INSTANCE = new ConnectionsListMarshaller();

    public static ConnectionsListMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConnectionsList connectionsList, ProtocolMarshaller protocolMarshaller) {
        if (connectionsList == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(connectionsList.connections(), CONNECTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

