/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;

public final class GetTriggersPaginator
implements SdkIterable<GetTriggersResponse> {
    private final GlueClient client;
    private final GetTriggersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetTriggersPaginator(GlueClient client, GetTriggersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTriggersResponseFetcher();
    }

    public Iterator<GetTriggersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetTriggersResponseFetcher
    implements NextPageFetcher<GetTriggersResponse> {
        private GetTriggersResponseFetcher() {
        }

        public boolean hasNextPage(GetTriggersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetTriggersResponse nextPage(GetTriggersResponse previousPage) {
            if (previousPage == null) {
                return GetTriggersPaginator.this.client.getTriggers(GetTriggersPaginator.this.firstRequest);
            }
            return GetTriggersPaginator.this.client.getTriggers((GetTriggersRequest)((Object)GetTriggersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

