/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;

public final class GetTablesPaginator
implements SdkIterable<GetTablesResponse> {
    private final GlueClient client;
    private final GetTablesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetTablesPaginator(GlueClient client, GetTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTablesResponseFetcher();
    }

    public Iterator<GetTablesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetTablesResponseFetcher
    implements NextPageFetcher<GetTablesResponse> {
        private GetTablesResponseFetcher() {
        }

        public boolean hasNextPage(GetTablesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetTablesResponse nextPage(GetTablesResponse previousPage) {
            if (previousPage == null) {
                return GetTablesPaginator.this.client.getTables(GetTablesPaginator.this.firstRequest);
            }
            return GetTablesPaginator.this.client.getTables((GetTablesRequest)((Object)GetTablesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

