/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;

public final class GetTableVersionsPaginator
implements SdkIterable<GetTableVersionsResponse> {
    private final GlueClient client;
    private final GetTableVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetTableVersionsPaginator(GlueClient client, GetTableVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTableVersionsResponseFetcher();
    }

    public Iterator<GetTableVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetTableVersionsResponseFetcher
    implements NextPageFetcher<GetTableVersionsResponse> {
        private GetTableVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetTableVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetTableVersionsResponse nextPage(GetTableVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetTableVersionsPaginator.this.client.getTableVersions(GetTableVersionsPaginator.this.firstRequest);
            }
            return GetTableVersionsPaginator.this.client.getTableVersions((GetTableVersionsRequest)((Object)GetTableVersionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

