/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;

public final class GetPartitionsPaginator
implements SdkIterable<GetPartitionsResponse> {
    private final GlueClient client;
    private final GetPartitionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetPartitionsPaginator(GlueClient client, GetPartitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetPartitionsResponseFetcher();
    }

    public Iterator<GetPartitionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetPartitionsResponseFetcher
    implements NextPageFetcher<GetPartitionsResponse> {
        private GetPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetPartitionsResponse nextPage(GetPartitionsResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionsPaginator.this.client.getPartitions(GetPartitionsPaginator.this.firstRequest);
            }
            return GetPartitionsPaginator.this.client.getPartitions((GetPartitionsRequest)((Object)GetPartitionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

