/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;

public final class GetCrawlersPaginator
implements SdkIterable<GetCrawlersResponse> {
    private final GlueClient client;
    private final GetCrawlersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetCrawlersPaginator(GlueClient client, GetCrawlersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCrawlersResponseFetcher();
    }

    public Iterator<GetCrawlersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetCrawlersResponseFetcher
    implements NextPageFetcher<GetCrawlersResponse> {
        private GetCrawlersResponseFetcher() {
        }

        public boolean hasNextPage(GetCrawlersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetCrawlersResponse nextPage(GetCrawlersResponse previousPage) {
            if (previousPage == null) {
                return GetCrawlersPaginator.this.client.getCrawlers(GetCrawlersPaginator.this.firstRequest);
            }
            return GetCrawlersPaginator.this.client.getCrawlers((GetCrawlersRequest)((Object)GetCrawlersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

