/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;

public final class GetCrawlerMetricsPaginator
implements SdkIterable<GetCrawlerMetricsResponse> {
    private final GlueClient client;
    private final GetCrawlerMetricsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetCrawlerMetricsPaginator(GlueClient client, GetCrawlerMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCrawlerMetricsResponseFetcher();
    }

    public Iterator<GetCrawlerMetricsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetCrawlerMetricsResponseFetcher
    implements NextPageFetcher<GetCrawlerMetricsResponse> {
        private GetCrawlerMetricsResponseFetcher() {
        }

        public boolean hasNextPage(GetCrawlerMetricsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetCrawlerMetricsResponse nextPage(GetCrawlerMetricsResponse previousPage) {
            if (previousPage == null) {
                return GetCrawlerMetricsPaginator.this.client.getCrawlerMetrics(GetCrawlerMetricsPaginator.this.firstRequest);
            }
            return GetCrawlerMetricsPaginator.this.client.getCrawlerMetrics((GetCrawlerMetricsRequest)((Object)GetCrawlerMetricsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

