/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;

public final class GetClassifiersPaginator
implements SdkIterable<GetClassifiersResponse> {
    private final GlueClient client;
    private final GetClassifiersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetClassifiersPaginator(GlueClient client, GetClassifiersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetClassifiersResponseFetcher();
    }

    public Iterator<GetClassifiersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetClassifiersResponseFetcher
    implements NextPageFetcher<GetClassifiersResponse> {
        private GetClassifiersResponseFetcher() {
        }

        public boolean hasNextPage(GetClassifiersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetClassifiersResponse nextPage(GetClassifiersResponse previousPage) {
            if (previousPage == null) {
                return GetClassifiersPaginator.this.client.getClassifiers(GetClassifiersPaginator.this.firstRequest);
            }
            return GetClassifiersPaginator.this.client.getClassifiers((GetClassifiersRequest)((Object)GetClassifiersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

