/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.DevEndpointCustomLibraries;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDevEndpointRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateDevEndpointRequest> {
    private final String endpointName;
    private final String publicKey;
    private final DevEndpointCustomLibraries customLibraries;
    private final Boolean updateEtlLibraries;

    private UpdateDevEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.publicKey = builder.publicKey;
        this.customLibraries = builder.customLibraries;
        this.updateEtlLibraries = builder.updateEtlLibraries;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public DevEndpointCustomLibraries customLibraries() {
        return this.customLibraries;
    }

    public Boolean updateEtlLibraries() {
        return this.updateEtlLibraries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLibraries());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateEtlLibraries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevEndpointRequest)) {
            return false;
        }
        UpdateDevEndpointRequest other = (UpdateDevEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.customLibraries(), other.customLibraries()) && Objects.equals(this.updateEtlLibraries(), other.updateEtlLibraries());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDevEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("PublicKey", (Object)this.publicKey()).add("CustomLibraries", (Object)this.customLibraries()).add("UpdateEtlLibraries", (Object)this.updateEtlLibraries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.of(clazz.cast(this.endpointName()));
            }
            case "PublicKey": {
                return Optional.of(clazz.cast(this.publicKey()));
            }
            case "CustomLibraries": {
                return Optional.of(clazz.cast(this.customLibraries()));
            }
            case "UpdateEtlLibraries": {
                return Optional.of(clazz.cast(this.updateEtlLibraries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String publicKey;
        private DevEndpointCustomLibraries customLibraries;
        private Boolean updateEtlLibraries;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevEndpointRequest model) {
            this.endpointName(model.endpointName);
            this.publicKey(model.publicKey);
            this.customLibraries(model.customLibraries);
            this.updateEtlLibraries(model.updateEtlLibraries);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final DevEndpointCustomLibraries.Builder getCustomLibraries() {
            return this.customLibraries != null ? this.customLibraries.toBuilder() : null;
        }

        @Override
        public final Builder customLibraries(DevEndpointCustomLibraries customLibraries) {
            this.customLibraries = customLibraries;
            return this;
        }

        public final void setCustomLibraries(DevEndpointCustomLibraries.BuilderImpl customLibraries) {
            this.customLibraries = customLibraries != null ? customLibraries.build() : null;
        }

        public final Boolean getUpdateEtlLibraries() {
            return this.updateEtlLibraries;
        }

        @Override
        public final Builder updateEtlLibraries(Boolean updateEtlLibraries) {
            this.updateEtlLibraries = updateEtlLibraries;
            return this;
        }

        public final void setUpdateEtlLibraries(Boolean updateEtlLibraries) {
            this.updateEtlLibraries = updateEtlLibraries;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDevEndpointRequest build() {
            return new UpdateDevEndpointRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, UpdateDevEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder publicKey(String var1);

        public Builder customLibraries(DevEndpointCustomLibraries var1);

        default public Builder customLibraries(Consumer<DevEndpointCustomLibraries.Builder> customLibraries) {
            return this.customLibraries((DevEndpointCustomLibraries)((DevEndpointCustomLibraries.Builder)DevEndpointCustomLibraries.builder().apply(customLibraries)).build());
        }

        public Builder updateEtlLibraries(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

